/** @type {import('next').NextConfig} */
const nextConfig = {
  reactStrictMode: true,
  compress: true,
  poweredByHeader: false, // Security: Hide Next.js header
  images: {
    remotePatterns: [
      { protocol: "https", hostname: "**" }, // Allow external images (unsplash, etc)
    ],
    formats: ['image/avif', 'image/webp'], // Optimize images
  },
};

export default nextConfig;