import mongoose from 'mongoose';

const UserSchema = new mongoose.Schema({
  email: {
    type: String,
    required: true,
    unique: true,
  },
  password: {
    type: String,
    required: true,
  },
  name: String,
  phone: String,
  role: {
    type: String,
    default: 'admin',
  },
  // Security Questions for Recovery
  securityQuestion1: String,
  securityAnswer1: String, // Will be hashed
  securityQuestion2: String,
  securityAnswer2: String, // Will be hashed
}, { timestamps: true });

export default mongoose.models.User || mongoose.model('User', UserSchema);