import mongoose from 'mongoose';

const GalleryItemSchema = new mongoose.Schema({
  name: String,
  title: String, // Backward compatibility
  images: [{ type: String }],
  imageUrl: { type: String, required: true },
  category: { type: String, default: 'General' },
  order: { type: Number, default: 0 }, // For Drag & Drop sorting
  status: { type: String, default: 'published' }
}, { timestamps: true });

export default mongoose.models.GalleryItem || mongoose.model('GalleryItem', GalleryItemSchema);
