import mongoose from 'mongoose';

const EventSchema = new mongoose.Schema({
  title: { type: String, required: true },
  slug: { type: String, unique: true, required: true },
  subtitle: String,
  posterImage: String,
  startDate: { type: Date, required: true },
  endDate: Date,
  timeText: String, // e.g. "10:00 AM - 5:00 PM"
  locationText: String,
  priceMembers: String,
  priceNonMembers: String,
  ctaText: { type: String, default: "View Details" },
  registrationUrl: String,
  detailsContent: String, // HTML or Markdown
  galleryImages: [{
    url: String,
    includeInGlobalGallery: { type: Boolean, default: false }
  }],
  status: {
    type: String,
    enum: ['published', 'draft', 'archived'],
    default: 'published'
  }
}, { timestamps: true });

// Virtual to determine if Upcoming or Past dynamically
EventSchema.virtual('isUpcoming').get(function() {
  const now = new Date();
  // If endDate exists, use that, otherwise use startDate
  const compareDate = this.endDate || this.startDate;
  return compareDate >= now;
});

// Ensure virtuals are included in JSON
EventSchema.set('toJSON', { virtuals: true });
EventSchema.set('toObject', { virtuals: true });

export default mongoose.models.Event || mongoose.model('Event', EventSchema);