'use client';
import React from 'react';
import { ArrowRight, Trophy, Heart, ChevronRight, Send } from 'lucide-react';
import Link from 'next/link';

interface MiscSectionsProps {
  galleryItems?: any[];
}

export function HallOfFameSection() {
  return (
    <section className="relative bg-[linear-gradient(180deg,#020617_0%,#08122d_100%)] border-t border-slate-800 py-16 md:py-20 overflow-hidden">
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.22),transparent_35%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.16),transparent_40%)]"></div>
      <div className="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid lg:grid-cols-2 gap-14 items-center relative z-10">
          <div>
            <div className="flex items-center gap-2 mb-4">
              <div className="w-10 h-0.5 bg-primary"></div>
              <span className="text-sm font-bold uppercase tracking-widest text-primary">Hall of Fame</span>
              <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
            </div>
            <h2 className="text-4xl font-bold text-white mb-6 font-display">
              Remembering <span className="text-primary">UKBCCI Icons</span>
            </h2>
            <p className="text-slate-300 mb-10 max-w-md text-lg leading-relaxed">
              Honoring the visionary leaders whose lifetime contributions shaped UK-Bangladesh trade relations and left an indelible mark on our community.
            </p>
            <div className="grid grid-cols-2 gap-4 max-w-md">
              <div className="rounded-2xl border border-white/15 bg-white/5 backdrop-blur px-4 py-4 shadow-sm">
                <p className="text-[11px] font-bold uppercase tracking-[0.18em] text-slate-400">Honorees</p>
                <p className="text-2xl font-bold text-white mt-1">03</p>
              </div>
              <div className="rounded-2xl border border-white/15 bg-white/5 backdrop-blur px-4 py-4 shadow-sm">
                <p className="text-[11px] font-bold uppercase tracking-[0.18em] text-slate-400">Legacy Since</p>
                <p className="text-2xl font-bold text-white mt-1">2016</p>
              </div>
            </div>
          </div>

          <div className="space-y-5">
            {[
              { name: "Mr Syed Manzur Elahi (Late)", year: "2019" },
              { name: "Mr Latifur Rahman (Late)", year: "2017" },
              { name: "Mr Abdur Rouf Chowdhury (Late)", year: "2016" }
            ].map((item, idx) => (
              <div key={idx} className="group relative overflow-hidden rounded-2xl border border-white/15 bg-white/[0.06] backdrop-blur p-5 flex items-center justify-between hover:border-white/30 transition cursor-pointer hover:-translate-y-1 hover:shadow-[0_26px_45px_-30px_rgba(2,6,23,0.9)] shadow-[0_20px_36px_-30px_rgba(2,6,23,0.85)]">
                <div className="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
                <div className="flex items-center gap-5 relative z-10">
                  <div className="w-12 h-12 rounded-xl bg-emerald-400/20 border border-emerald-300/30 flex items-center justify-center text-primary shadow-lg shadow-black/20 group-hover:scale-105 transition">
                    <Trophy size={22} />
                  </div>
                  <div>
                    <h4 className="text-white text-base font-bold group-hover:text-primary transition">{item.name}</h4>
                    <p className="text-sm text-slate-300">Lifetime Achievement Award</p>
                  </div>
                </div>
                <div className="relative z-10 text-right">
                  <div className="text-slate-200 font-display text-2xl font-bold">{item.year}</div>
                  <p className="text-[11px] uppercase tracking-wider text-slate-400 font-semibold">Honoree</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}

export function EventMomentsSection({ galleryItems = [] }: MiscSectionsProps) {
  return (
    <section className="relative py-24 bg-[linear-gradient(180deg,#020617_0%,#071333_100%)] overflow-hidden">
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.3),transparent_40%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.22),transparent_45%)]"></div>
      <div className="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-end mb-12 relative z-10 rounded-3xl border border-white/10 bg-white/[0.03] backdrop-blur px-6 py-7 md:px-8 md:py-8">
          <div>
            <div className="flex items-center gap-2 mb-4">
              <div className="w-10 h-0.5 bg-primary"></div>
              <span className="text-sm font-bold uppercase tracking-widest text-primary">Gallery</span>
              <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
            </div>
            <h2 className="text-4xl font-bold text-white font-display">
              Event <span className="text-primary">Moments</span>
            </h2>
            <p className="text-slate-300/90 mt-3 text-base">Highlights from our latest UKBCCI activities.</p>
          </div>
          <Link href="/gallery" className="hidden sm:flex items-center gap-2 text-white/80 hover:text-white transition text-sm font-semibold uppercase tracking-wider border border-white/20 rounded-full px-6 py-3 hover:bg-white/10 shadow-sm">
            View Gallery <ArrowRight size={16} />
          </Link>
        </div>
        <div className="relative z-10 grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-4">
          {galleryItems.slice(0, 20).map((item, idx) => (
            <div key={idx} className="group relative aspect-square rounded-2xl overflow-hidden shadow-[0_24px_44px_-30px_rgba(0,0,0,0.9)] hover:shadow-[0_28px_48px_-28px_rgba(0,0,0,0.95)] transition-all duration-300 bg-slate-800 border border-white/15 hover:border-white/30">
              <img
                src={item.imageUrl}
                alt={item.title || "Gallery"}
                loading="lazy"
                className="w-full h-full object-cover group-hover:scale-110 transition duration-700"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/65 via-black/5 to-transparent opacity-0 group-hover:opacity-100 transition duration-300"></div>
              <div className="absolute top-2 left-2 h-1.5 w-14 rounded-full bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C] opacity-0 group-hover:opacity-100 transition"></div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}

export default function MiscSections() {
  return (
    <>
      {/* Remembrance */}
      <section className="relative pt-6 pb-12 bg-[linear-gradient(180deg,#ffffff_0%,#f7fafc_100%)] border-t border-slate-200 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_right,rgba(14,58,138,0.08),transparent_35%),radial-gradient(circle_at_bottom_left,rgba(22,163,74,0.1),transparent_40%)]"></div>
        <div className="max-w-5xl mx-auto px-4 sm:px-6 text-center">
          <div className="w-14 h-14 bg-white border border-slate-200 rounded-full flex items-center justify-center text-primary mx-auto mb-5 shadow-sm relative z-10">
            <Heart size={24} />
          </div>
          <p className="text-sm font-bold uppercase tracking-[0.2em] text-primary mb-3 relative z-10">In Loving Memory</p>
          <h2 className="text-4xl font-bold text-slate-900 mb-4 font-display relative z-10">In <span className="text-primary">Remembrance</span></h2>
          <p className="text-slate-600 max-w-2xl mx-auto mb-12 relative z-10">
            We honor respected leaders whose guidance and dedication shaped UKBCCI's journey and legacy.
          </p>

          <div className="grid md:grid-cols-2 gap-8">
            <div className="bg-white p-8 rounded-2xl shadow-[0_18px_36px_-28px_rgba(15,23,42,0.45)] border border-slate-200 text-left flex gap-6 hover:shadow-[0_22px_40px_-26px_rgba(15,23,42,0.5)] transition relative">
              <div className="absolute top-0 left-0 right-0 h-1 rounded-t-2xl bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
              <div className="w-1.5 h-full bg-slate-200 rounded-full mt-2"></div>
              <div>
                <h4 className="text-xl font-bold text-slate-900 mb-1">Mr M A Rouf JP</h4>
                <p className="text-sm text-primary font-bold mb-2 uppercase tracking-wide">Senior Vice President & Director</p>
                <p className="text-xs text-slate-500 italic mb-3">2014 - 2022</p>
                <p className="text-base text-slate-600 leading-relaxed">A renowned business person and lovely gentleman with a kind heart.</p>
              </div>
            </div>
            <div className="bg-white p-8 rounded-2xl shadow-[0_18px_36px_-28px_rgba(15,23,42,0.45)] border border-slate-200 text-left flex gap-6 hover:shadow-[0_22px_40px_-26px_rgba(15,23,42,0.5)] transition relative">
              <div className="absolute top-0 left-0 right-0 h-1 rounded-t-2xl bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
              <div className="w-1.5 h-full bg-slate-200 rounded-full mt-2"></div>
              <div>
                <h4 className="text-xl font-bold text-slate-900 mb-1">Mr M A Gani</h4>
                <p className="text-sm text-primary font-bold mb-2 uppercase tracking-wide">Vice President & Director</p>
                <p className="text-xs text-slate-500 italic mb-3">2015 - 2022</p>
                <p className="text-base text-slate-600 leading-relaxed">A business person with great integrity; always there to help.</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-24 bg-slate-900 text-white relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-blue-900 to-slate-900 opacity-90"></div>
        <div className="absolute top-0 right-0 w-80 h-80 bg-primary/20 rounded-full blur-3xl transform translate-x-1/2 -translate-y-1/2"></div>
        <div className="absolute bottom-0 left-0 w-80 h-80 bg-blue-500/20 rounded-full blur-3xl transform -translate-x-1/2 translate-y-1/2"></div>

        <div className="relative max-w-4xl mx-auto px-4 text-center z-10">
          <h2 className="text-4xl md:text-6xl font-bold mb-8 font-display">
            Ready to Grow Your <span className="text-primary">Business?</span>
          </h2>
          <p className="text-blue-100 mb-12 text-xl max-w-2xl mx-auto leading-relaxed">
            Join UKBCCI today and unlock opportunities for growth, networking, and success in UK-Bangladesh trade.
          </p>
          <div className="flex flex-wrap justify-center gap-5">
            <a href="#membership" className="bg-primary hover:bg-primary-dark text-white px-10 py-4 rounded-full font-bold transition shadow-lg shadow-green-900/30 flex items-center gap-2 text-base">
              Become a Member <ArrowRight size={18} />
            </a>
            <a href="#contact" className="bg-transparent border border-white/30 hover:bg-white/10 text-white px-10 py-4 rounded-full font-bold transition flex items-center gap-2 text-base">
              Contact Us <ChevronRight size={18} />
            </a>
          </div>
        </div>
      </section>

      {/* Newsletter Section */}
      <div className="relative bg-[linear-gradient(180deg,#ffffff_0%,#f6f8fb_100%)] border-t border-slate-200 py-16 overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.08),transparent_35%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.08),transparent_40%)]"></div>
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="relative bg-white rounded-3xl p-8 md:p-12 flex flex-col md:flex-row items-center justify-between gap-10 border border-slate-200 shadow-[0_22px_44px_-30px_rgba(15,23,42,0.5)]">
            <div className="absolute top-0 left-0 right-0 h-1 rounded-t-3xl bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
            <div>
              <h3 className="text-3xl font-bold text-slate-900 mb-3">Stay Connected with <span className="text-primary">UKBCCI</span></h3>
              <p className="text-slate-600 text-base max-w-md">Subscribe to our newsletter for the latest news, events, and business opportunities.</p>
            </div>
            <form className="flex flex-col sm:flex-row w-full md:w-auto gap-3" onSubmit={(e) => e.preventDefault()}>
              <input
                type="email"
                placeholder="Enter your email"
                className="bg-white border border-slate-300 text-slate-900 rounded-full px-6 py-4 w-full md:w-80 focus:ring-2 focus:ring-primary focus:border-transparent outline-none text-base placeholder-slate-400"
              />
              <button type="submit" className="bg-slate-900 hover:bg-primary text-white px-8 py-4 rounded-full font-bold transition flex items-center justify-center gap-2 text-base shadow-lg">
                Subscribe <Send size={16} />
              </button>
            </form>
          </div>
        </div>
      </div>
    </>
  );
}
