import React from 'react';
import { CheckCircle, Star } from 'lucide-react';
import { MembershipPlan } from '../types';

const plans: MembershipPlan[] = [
  {
    name: "Student",
    price: 50,
    features: ["Networking events", "Educational resources", "Mentorship", "Career guidance"]
  },
  {
    name: "Regular",
    price: 200,
    features: ["All Student benefits", "Priority access", "Directory listing", "Newsletters", "Consultations"],
    highlight: true
  },
  {
    name: "Corporate",
    price: 500,
    features: ["All Regular benefits", "Sponsorships", "Account manager", "Trade missions", "VIP access"]
  }
];

const Membership: React.FC = () => {
  return (
    <section id="membership" className="relative py-24 bg-[linear-gradient(180deg,#ffffff_0%,#f2f7ff_100%)] text-slate-900 overflow-hidden border-t border-slate-200">
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.08),transparent_35%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.08),transparent_40%)]"></div>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center max-w-2xl mx-auto mb-20">
          <div className="flex items-center justify-center gap-3 mb-5">
            <div className="w-10 h-0.5 bg-primary"></div>
            <span className="text-sm font-bold uppercase tracking-widest text-primary">Membership</span>
            <div className="w-10 h-0.5 bg-primary"></div>
            <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
          </div>
          <h2 className="text-4xl md:text-5xl font-bold font-display mb-6">Join <span className="text-primary">UKBCCI</span> Today</h2>
          <p className="text-slate-600 text-lg leading-relaxed">Choose the plan that fits your needs and unlock exclusive benefits designed to elevate your business.</p>
        </div>

        <div className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
          {plans.map((plan, index) => (
            <div 
              key={index} 
              className={`
                bg-white rounded-3xl p-8 lg:p-10 flex flex-col relative transition-all duration-300 border border-slate-200 shadow-[0_22px_42px_-30px_rgba(15,23,42,0.45)]
                ${plan.highlight 
                  ? 'border-2 border-primary shadow-2xl shadow-primary/20 transform md:-translate-y-3' 
                  : 'hover:border-slate-300 hover:-translate-y-1'
                }
              `}
            >
              <div className="absolute top-0 left-0 right-0 h-1 rounded-t-3xl bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
              {plan.highlight && (
                <div className="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-primary text-white text-sm font-bold px-5 py-1.5 rounded-full flex items-center gap-1.5 shadow-lg">
                  <Star size={14} fill="currentColor" /> Most Popular
                </div>
              )}
              
              <h3 className={`text-2xl font-bold mb-4 ${plan.highlight ? 'text-primary' : 'text-slate-900'}`}>{plan.name}</h3>
              <div className={`text-4xl font-bold mb-1 ${plan.highlight ? 'text-primary' : 'text-slate-900'}`}>
                £{plan.price}<span className="text-base font-normal text-slate-500">/year</span>
              </div>
              <hr className="border-slate-200 my-8" />
              
              <ul className="space-y-4 mb-10 text-base text-slate-600 flex-1">
                {plan.features.map((feature, idx) => (
                  <li key={idx} className="flex items-center gap-3">
                    <CheckCircle size={18} className="text-primary flex-shrink-0" /> 
                    {feature}
                  </li>
                ))}
              </ul>
              
              <a href="#" className={`block text-center w-full py-3.5 rounded-xl font-bold text-base transition ${plan.highlight ? 'bg-primary hover:bg-primary-dark text-white shadow-lg shadow-primary/25' : 'border border-slate-300 text-slate-800 hover:bg-slate-50'}`}>
                Get Started
              </a>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default Membership;
