import React from 'react';
import { Factory, Landmark, PlaneTakeoff, Briefcase, CheckCircle2, ArrowRight } from 'lucide-react';
import Link from 'next/link';

const focusAreas = [
  {
    title: 'Supply Chain',
    text: 'Support for sourcing, buyer connections, and market entry between UK and Bangladesh.',
    icon: Factory,
  },
  {
    title: 'Finance & Investment',
    text: 'Facilitating cross-border business confidence through practical commercial guidance.',
    icon: Landmark,
  },
  {
    title: 'Trade Missions',
    text: 'High-impact delegations to build trusted relationships with decision makers.',
    icon: PlaneTakeoff,
  },
  {
    title: 'SME Growth Advisory',
    text: 'Hands-on business advisory for SMEs scaling across both markets.',
    icon: Briefcase,
  },
];

const journey = [
  'Join UKBCCI membership and connect to our business network.',
  'Get expert market insights and cross-border advisory support.',
  'Participate in networking events, roundtables, and trade missions.',
  'Build long-term UK-Bangladesh partnerships and growth outcomes.',
];

export function HomeOpportunityAreas() {
  return (
    <section className="relative py-24 bg-[linear-gradient(180deg,#ffffff_0%,#f2f7ff_100%)] overflow-hidden border-t border-slate-200">
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.08),transparent_35%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.08),transparent_40%)]"></div>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div className="flex items-center gap-2 mb-4">
          <div className="w-10 h-0.5 bg-primary"></div>
          <span className="text-sm font-bold uppercase tracking-widest text-primary">Strategic Focus</span>
          <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
        </div>
        <h2 className="text-4xl md:text-5xl font-bold text-slate-900 font-display mb-3">
          UK-BD <span className="text-primary">Opportunity Areas</span>
        </h2>
        <p className="text-slate-600 max-w-3xl mb-12">
          We connect members to practical opportunities in sectors where UK-Bangladesh collaboration creates measurable business value.
        </p>

        <div className="grid md:grid-cols-2 xl:grid-cols-4 gap-5">
          {focusAreas.map((area) => {
            const Icon = area.icon;
            return (
              <div
                key={area.title}
                className="group rounded-2xl border border-slate-200 bg-white p-6 hover:-translate-y-1 transition duration-300 shadow-[0_20px_40px_-30px_rgba(15,23,42,0.35)] hover:shadow-[0_26px_46px_-30px_rgba(15,23,42,0.45)]"
              >
                <div className="w-12 h-12 rounded-xl bg-emerald-100 text-primary border border-emerald-200 flex items-center justify-center mb-4 group-hover:bg-primary group-hover:text-white transition">
                  <Icon size={24} />
                </div>
                <h3 className="text-slate-900 font-bold text-lg mb-2">{area.title}</h3>
                <p className="text-slate-600 text-sm leading-relaxed">{area.text}</p>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
}

export function HomeGrowthJourney() {
  return (
    <section className="relative py-24 bg-[linear-gradient(180deg,#ffffff_0%,#f3f7fc_100%)] overflow-hidden border-t border-slate-200">
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_right,rgba(14,58,138,0.08),transparent_36%),radial-gradient(circle_at_bottom_left,rgba(190,18,60,0.07),transparent_42%)]"></div>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div>
            <div className="flex items-center gap-2 mb-4">
              <div className="w-10 h-0.5 bg-primary"></div>
              <span className="text-sm font-bold uppercase tracking-widest text-primary">Growth Journey</span>
              <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
            </div>
            <h2 className="text-4xl md:text-5xl font-bold text-slate-900 font-display mb-5">
              How UKBCCI Supports <span className="text-primary">Your Growth</span>
            </h2>
            <p className="text-slate-600 text-lg leading-relaxed mb-8">
              From first connection to long-term expansion, UKBCCI helps members move faster with trusted guidance and business access.
            </p>
            <Link
              href="/membership"
              className="inline-flex items-center justify-center rounded-full bg-slate-900 px-8 py-4 text-base font-semibold text-white shadow-[0_16px_32px_-24px_rgba(15,23,42,0.7)] transition hover:bg-primary"
            >
              Join UKBCCI <ArrowRight size={18} className="ml-2" />
            </Link>
          </div>

          <div className="rounded-3xl border border-slate-200 bg-white p-6 md:p-8 shadow-[0_28px_50px_-34px_rgba(15,23,42,0.45)]">
            <div className="space-y-4">
              {journey.map((step, index) => (
                <div key={step} className="flex items-start gap-4 rounded-2xl border border-slate-200 bg-slate-50 px-4 py-4">
                  <div className="w-7 h-7 rounded-full bg-primary text-white text-xs font-bold flex items-center justify-center mt-0.5 flex-shrink-0">
                    {index + 1}
                  </div>
                  <div className="text-slate-700 leading-relaxed flex items-start gap-2">
                    <CheckCircle2 size={16} className="text-primary mt-1 flex-shrink-0" />
                    <span>{step}</span>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
