import React from 'react';
import { ArrowRight, ChevronRight } from 'lucide-react';

const Hero: React.FC = () => {
  return (
    <>
      <header className="relative bg-slate-900 min-h-[600px] flex items-center overflow-hidden">
        {/* Background Image with Gradient Overlay */}
        <div 
          className="absolute inset-0 bg-cover bg-center z-0"
          style={{ backgroundImage: "url('/hero-ukbcci.jpg')" }}
        ></div>
        <div className="absolute inset-0 bg-gradient-to-r from-slate-900/70 via-slate-900/45 to-transparent z-10"></div>

        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full py-20 z-20">
          <div className="max-w-2xl">
            <div className="inline-flex items-center px-4 py-1.5 rounded-full border border-slate-600 bg-slate-800/50 backdrop-blur-sm text-sm font-medium text-slate-300 mb-6">
              UK-Bangladesh Catalysts of Commerce & Industry
            </div>
            <h1 className="text-5xl md:text-7xl font-bold text-white mb-6 font-display leading-tight">
              Empowering <br />
              <span className="text-gradient">UK–BD Trade</span>
            </h1>
            <p className="text-xl text-slate-300 mb-10 max-w-xl leading-relaxed">
              Building stronger trade, investment, and business connections between the United Kingdom and Bangladesh. Join a network of visionaries.
            </p>
            <div className="flex flex-wrap gap-4">
              <a href="#membership" className="bg-primary hover:bg-primary-dark text-white px-8 py-4 rounded-full font-bold transition shadow-lg shadow-green-900/20 flex items-center gap-2 group text-base">
                Join UKBCCI <ArrowRight size={20} className="group-hover:translate-x-1 transition-transform" />
              </a>
              <a href="#about" className="bg-white/10 border border-white/40 hover:bg-white/20 text-white px-8 py-4 rounded-full font-bold transition flex items-center gap-2 text-base">
                Learn More <ChevronRight size={20} />
              </a>
            </div>
          </div>
        </div>

        {/* Rotating Badge */}
        <div className="absolute right-16 lg:right-24 bottom-20 hidden md:block opacity-80 z-20">
          <div className="relative w-36 h-36 flex items-center justify-center">
            <svg className="w-full h-full animate-spin-slow text-white" viewBox="0 0 100 100">
              <defs>
                <path id="circlePath" d="M 50, 50 m -37, 0 a 37,37 0 1,1 74,0 a 37,37 0 1,1 -74,0" />
              </defs>
              <text fill="currentColor" fontSize="12" fontWeight="bold">
                <textPath xlinkHref="#circlePath">UK-BANGLADESH CATALYSTS • COMMERCE •</textPath>
              </text>
            </svg>
            <div className="absolute bg-white rounded-full w-14 h-14 flex items-center justify-center overflow-hidden">
              <img src="/logo.png" alt="Logo" className="w-12 h-auto" />
            </div>
          </div>
        </div>
      </header>

      {/* Stats Section */}
      <section className="bg-slate-900 border-b border-slate-800">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 py-12">
            <div className="text-center border-r border-slate-800 last:border-0">
              <div className="text-4xl font-bold text-white mb-2">500+</div>
              <div className="text-sm uppercase tracking-widest text-slate-500 font-medium">Members</div>
            </div>
            <div className="text-center border-r border-slate-800 last:border-0">
              <div className="text-4xl font-bold text-white mb-2">£50M+</div>
              <div className="text-sm uppercase tracking-widest text-slate-500 font-medium">Trade Value</div>
            </div>
            <div className="text-center border-r border-slate-800 last:border-0">
              <div className="text-4xl font-bold text-white mb-2">100+</div>
              <div className="text-sm uppercase tracking-widest text-slate-500 font-medium">Events</div>
            </div>
            <div className="text-center">
              <div className="text-4xl font-bold text-white mb-2">20+</div>
              <div className="text-sm uppercase tracking-widest text-slate-500 font-medium">Trade Missions</div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default Hero;
