import React from 'react';
import { ArrowRight, Users, Briefcase, PlaneTakeoff, Lightbulb } from 'lucide-react';

const About: React.FC = () => {
  const pillars = [
    {
      title: 'Networking',
      description: 'Connect with decision-makers and strategic partners',
      icon: Users,
    },
    {
      title: 'Advisory',
      description: 'Cross-border trade support from experts',
      icon: Briefcase,
    },
    {
      title: 'Trade Missions',
      description: 'Structured UK-Bangladesh market visits',
      icon: PlaneTakeoff,
    },
    {
      title: 'Intelligence',
      description: 'Practical reports and opportunity mapping',
      icon: Lightbulb,
    },
  ];

  return (
    <section
      id="about"
      className="relative overflow-hidden bg-[linear-gradient(180deg,#ffffff_0%,#f4f7fc_100%)] py-24"
    >
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.16),transparent_35%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.12),transparent_38%)]" />
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          <div className="relative">
            <div className="relative h-[380px] sm:h-[460px] lg:h-[560px] rounded-3xl border border-slate-200 shadow-[0_36px_64px_-36px_rgba(15,23,42,0.7)] bg-white p-3 flex flex-col">
              <div className="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C] z-10"></div>
              <div className="flex-1 min-h-0">
                <img
                  src="/2ndsection.jpg"
                  alt="UKBCCI Group"
                  className="w-full h-full rounded-2xl object-contain object-center"
                />
              </div>
              <div className="mt-3 rounded-2xl border border-slate-200 bg-[linear-gradient(90deg,#ffffff_0%,#f8fbff_100%)] px-4 py-3">
                <p className="text-[11px] sm:text-xs font-semibold uppercase tracking-[0.2em] text-primary">
                  UKBCCI Mission
                </p>
                <p className="mt-1 text-sm sm:text-base font-semibold text-slate-900">
                  Empowering UK-Bangladesh businesses through trust, trade, and long-term collaboration.
                </p>
              </div>
            </div>
            <div className="absolute -z-10 -bottom-6 -left-6 w-full h-full rounded-3xl border-2 border-slate-200" />
            <div className="absolute -z-10 -top-6 -right-6 w-40 h-40 bg-emerald-200/40 rounded-full blur-3xl"></div>
          </div>

          <div className="h-full flex flex-col justify-center">
            <div className="flex items-center gap-2 mb-4">
              <div className="w-10 h-0.5 bg-primary"></div>
              <span className="text-sm font-bold uppercase tracking-widest text-primary">About Us</span>
              <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
            </div>
            <h2 className="text-4xl md:text-5xl font-bold text-slate-900 mb-6 font-display">
              Building Bridges Between <span className="text-primary">UK & Bangladesh</span>
            </h2>
            <p className="text-slate-600 mb-6 leading-relaxed text-lg">
              UKBCCI — UK Bangladesh Catalysts of Commerce & Industry — serves as a vital bridge between the United Kingdom and Bangladesh. We bring together entrepreneurs, business leaders, and organisations to create opportunities and foster growth.
            </p>
            <div className="grid grid-cols-1 sm:grid-cols-2 gap-5 mb-8">
              {pillars.map((pillar) => {
                const Icon = pillar.icon;
                return (
                  <div
                    key={pillar.title}
                    className="group flex gap-5 rounded-2xl border border-slate-200 bg-white px-5 py-4 shadow-sm transition duration-300 hover:-translate-y-1 hover:border-slate-300 hover:shadow-lg"
                  >
                    <div className="w-12 h-12 rounded-xl bg-emerald-100 group-hover:bg-primary group-hover:text-white transition flex items-center justify-center text-primary flex-shrink-0">
                      <Icon size={24} />
                    </div>
                    <div>
                      <h4 className="font-bold text-slate-900 text-base">{pillar.title}</h4>
                      <p className="text-sm text-slate-500 mt-1">{pillar.description}</p>
                    </div>
                  </div>
                );
              })}
            </div>

            <a
              href="/about"
              className="inline-flex items-center justify-center rounded-full bg-slate-900 px-8 py-4 text-base font-semibold text-white shadow-[0_16px_32px_-24px_rgba(15,23,42,0.7)] transition hover:bg-primary"
            >
              Discover More <ArrowRight size={18} className="ml-2" />
            </a>
          </div>
        </div>
      </div>
    </section>
  );
};

export default About;
