import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import { MapPin } from 'lucide-react';

export default function RegionsPage() {
  const ukRegions = [
    { name: 'London', type: 'Region' },
    { name: 'Midlands', type: 'Region' },
    { name: 'North', type: 'Region' },
    { name: 'Scotland', type: 'Region' },
    { name: 'Wales', type: 'Region' },
    { name: 'South West', type: 'Region' },
    { name: 'East of England', type: 'Region' },
  ];

  const bdDivisions = [
    { name: 'Dhaka', type: 'Division' },
    { name: 'Chittagong', type: 'Division' },
    { name: 'Sylhet', type: 'Division' },
    { name: 'Rajshahi', type: 'Division' },
    { name: 'Khulna', type: 'Division' },
    { name: 'Barishal', type: 'Division' },
    { name: 'Rangpur', type: 'Division' },
    { name: 'Mymensingh', type: 'Division' },
  ];

  return (
    <div className="min-h-screen flex flex-col bg-slate-50 dark:bg-slate-900">
      <Navbar />
      
      <main className="flex-grow py-16 px-4 sm:px-6 lg:px-8 max-w-7xl mx-auto w-full">
        
        {/* UK Section */}
        <div className="mb-16">
          <div className="flex items-center gap-4 mb-8">
            <span className="bg-primary text-white px-5 py-1.5 rounded-full text-sm font-bold">United Kingdom</span>
            <h2 className="text-2xl font-bold text-slate-800 dark:text-white font-display">UK Regions</h2>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {ukRegions.map((region, idx) => (
              <div key={idx} className="bg-white dark:bg-slate-800 rounded-xl p-6 shadow-sm border border-slate-200 dark:border-slate-700 flex justify-between items-center hover:shadow-md transition group cursor-default">
                <div>
                  <h3 className="font-bold text-slate-900 dark:text-white mb-1 text-lg">{region.name}</h3>
                  <p className="text-xs text-slate-400 uppercase tracking-wide font-medium">{region.type}</p>
                </div>
                <div className="w-10 h-10 rounded-full bg-green-50 dark:bg-slate-700 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition">
                  <MapPin size={20} />
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* Bangladesh Section */}
        <div>
          <div className="flex items-center gap-4 mb-8">
            <span className="bg-primary text-white px-5 py-1.5 rounded-full text-sm font-bold">Bangladesh</span>
            <h2 className="text-2xl font-bold text-slate-800 dark:text-white font-display">Bangladesh Divisions</h2>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {bdDivisions.map((division, idx) => (
              <div key={idx} className="bg-white dark:bg-slate-800 rounded-xl p-6 shadow-sm border border-slate-200 dark:border-slate-700 flex justify-between items-center hover:shadow-md transition group cursor-default">
                <div>
                  <h3 className="font-bold text-slate-900 dark:text-white mb-1 text-lg">{division.name}</h3>
                  <p className="text-xs text-slate-400 uppercase tracking-wide font-medium">{division.type}</p>
                </div>
                <div className="w-10 h-10 rounded-full bg-green-50 dark:bg-slate-700 flex items-center justify-center text-primary group-hover:bg-primary group-hover:text-white transition">
                  <MapPin size={20} />
                </div>
              </div>
            ))}
          </div>
        </div>

      </main>
      <Footer />
    </div>
  );
}