import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import { Trophy, Star, Medal } from 'lucide-react';

export default function IconsPage() {
  const icons = [
    {
      name: "Mr Syed Manzur Elahi (Late)",
      year: "2019",
      description: "Mr. Syed Manzur Elahi was the Founding Chairman of Mutual Trust Bank Ltd. (MTB) and Pioneer Insurance Company Limited. He was the Chairman of Apex Group, a leading business conglomerate in Bangladesh. Besides being an eminent industrialist, he was also appointed Adviser to the Caretaker Government of Bangladesh, twice (1996 & 2001), for his leadership qualities, professionalism and non-partisanship.",
      colorClass: "border-yellow-500" // Custom color for border
    },
    {
      name: "Mr Latifur Rahman (Late)",
      year: "2017",
      description: "Mr Latifur Rahman was the Chairman and CEO of Transcom Group, one of the leading conglomerates in the country which has been operating in Bangladesh since 1885, having started the business with tea plantation. He started his business career in 1967 and took over the reins of the group steering his enterprise through very challenging times after the country gained independence in 1971.",
      colorClass: "border-primary"
    },
    {
      name: "Mr Abdur Rouf Chowdhury (Late)",
      year: "2016",
      description: "Mr Abdur Rouf Chowdhury was the Chairman and founder of Rangs Group and Sea Resources Group, which he built into leading conglomerates in Bangladesh. Sea Resources Group operates the country's largest fleet of ocean fishing trawlers and is the leading exporter of seafood. Alongside his business achievements, Mr Chowdhury remained deeply committed to philanthropy and social development.",
      colorClass: "border-primary"
    }
  ];

  return (
    <div className="min-h-screen flex flex-col bg-white dark:bg-slate-900">
      <Navbar />
      
      <main className="flex-grow">
        {/* Header Section */}
        <div className="bg-[#0F172A] text-white py-20 text-center relative overflow-hidden">
           <div className="absolute top-0 left-0 w-full h-full bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] opacity-10"></div>
           <div className="relative z-10 max-w-4xl mx-auto px-4">
              <div className="w-16 h-16 mx-auto mb-6 text-primary">
                 <Trophy size={64} strokeWidth={1.5} />
              </div>
              <h1 className="text-4xl md:text-5xl font-bold font-display mb-4">
                 Remembering UKBCCI <span className="text-primary">Icons</span>
              </h1>
              <p className="text-slate-400 text-lg max-w-2xl mx-auto">
                 Celebrating our award winners and lifetime achievers who exemplify excellence
              </p>
           </div>
        </div>

        {/* Content Section */}
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 -mt-10 pb-20 relative z-20">
           <div className="grid md:grid-cols-3 gap-8">
              
              {icons.map((icon, idx) => (
                <div key={idx} className={`bg-white dark:bg-slate-800 rounded-xl overflow-hidden border-t-8 ${icon.colorClass || 'border-primary'} shadow-xl hover:shadow-2xl transition duration-300 flex flex-col items-center text-center p-8 group`}>
                   
                   {/* Medal Icon Wrapper */}
                   <div className="w-20 h-20 bg-yellow-50 dark:bg-slate-700 rounded-full flex items-center justify-center text-yellow-500 mb-6 group-hover:scale-110 transition duration-500">
                      <Medal size={36} />
                   </div>

                   {/* Badge */}
                   <div className="inline-flex items-center gap-1.5 border border-primary text-primary text-[10px] uppercase font-bold px-3 py-1 rounded-full mb-5">
                      Lifetime Achievement
                   </div>

                   <h2 className="text-xl font-bold text-slate-900 dark:text-white mb-3">{icon.name}</h2>
                   
                   <div className="flex items-center gap-2 text-yellow-500 font-bold text-sm mb-3">
                      <Star size={16} fill="currentColor" /> Life Time Achievement Award
                   </div>
                   
                   <p className="text-primary font-bold text-sm mb-6">Year: {icon.year}</p>
                   
                   <p className="text-slate-600 dark:text-slate-400 text-sm leading-relaxed text-center">
                      {icon.description}
                   </p>
                </div>
              ))}

           </div>
        </div>
      </main>

      <Footer />
    </div>
  );
}