'use client';

import { useEffect } from 'react';

export default function GlobalError({
    error,
    reset,
}: {
    error: Error & { digest?: string };
    reset: () => void;
}) {
    useEffect(() => {
        // Log the error to an error reporting service
        console.error('Global Error caught:', error);
    }, [error]);

    return (
        <html>
            <body className="flex min-h-screen flex-col items-center justify-center bg-gray-50 p-4 text-center">
                <h2 className="mb-4 text-2xl font-bold text-gray-900">Something went wrong!</h2>
                <p className="mb-8 text-gray-600">
                    {/* Show a friendly message, but log the real one */}
                    We apologize for the inconvenience. The application encountered a critical error.
                </p>
                <button
                    className="rounded bg-blue-600 px-4 py-2 text-white hover:bg-blue-700 transition"
                    onClick={
                        // Attempt to recover by trying to re-render the segment
                        () => reset()
                    }
                >
                    Try again
                </button>
            </body>
        </html>
    );
}
