import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import Newsletter from '@/components/Newsletter';
import { MapPin, Mail, Phone, Clock, ArrowRight } from 'lucide-react';
import Link from 'next/link';

export default function ContactPage() {
  return (
    <div className="min-h-screen flex flex-col bg-slate-50 dark:bg-slate-900">
      <Navbar />
      
      <main className="flex-grow">
        {/* Header Section */}
        <div className="bg-[#0F172A] text-white py-20 text-center relative overflow-hidden">
           {/* Background dots pattern */}
           <div className="absolute inset-0 z-0 opacity-10" style={{ backgroundImage: 'radial-gradient(#ffffff 1px, transparent 1px)', backgroundSize: '20px 20px' }}></div>
           
           <div className="relative z-10 max-w-4xl mx-auto px-4">
              <div className="inline-block border border-slate-600 bg-slate-800/50 backdrop-blur-sm px-4 py-1 rounded-full text-xs font-medium text-slate-300 mb-5">
                Get In Touch
              </div>
              <h1 className="text-4xl md:text-6xl font-bold font-display mb-5">
                 Contact <span className="text-primary">Us</span>
              </h1>
              <p className="text-slate-400 text-lg max-w-2xl mx-auto">
                 Get in touch with UKBCCI - we&apos;re here to help your business succeed
              </p>
           </div>
        </div>

        {/* Content Section */}
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
           <div className="grid lg:grid-cols-3 gap-8">
              
              {/* Left Column: Form */}
              <div className="lg:col-span-2">
                 <div className="bg-white dark:bg-slate-800 rounded-xl shadow-sm border border-slate-200 dark:border-slate-700 overflow-hidden h-full">
                    {/* Embedded Form Widget */}
                    <iframe 
                      src="https://link.webvortexltd.com/widget/form/Mkrpo2AAnK3FFhU8CjUw"
                      style={{ width: '100%', height: '850px', border: 'none' }}
                      title="Contact Form"
                      className="w-full"
                    ></iframe>
                 </div>
              </div>

              {/* Right Column: Info & Links */}
              <div className="space-y-8">
                 
                 {/* Contact Information */}
                 <div className="bg-white dark:bg-slate-800 rounded-xl shadow-sm border border-slate-200 dark:border-slate-700 p-8">
                    <h3 className="text-xl font-bold text-slate-900 dark:text-white mb-6">Contact Information</h3>
                    
                    <div className="space-y-6">
                       <div className="flex items-start gap-4">
                          <div className="w-10 h-10 rounded-full bg-green-50 dark:bg-slate-700 flex items-center justify-center text-primary flex-shrink-0">
                             <MapPin size={20} />
                          </div>
                          <div>
                             <h4 className="font-bold text-slate-900 dark:text-white text-sm">Address</h4>
                             <p className="text-slate-500 text-sm">London, United Kingdom</p>
                          </div>
                       </div>

                       <div className="flex items-start gap-4">
                          <div className="w-10 h-10 rounded-full bg-green-50 dark:bg-slate-700 flex items-center justify-center text-primary flex-shrink-0">
                             <Mail size={20} />
                          </div>
                          <div>
                             <h4 className="font-bold text-slate-900 dark:text-white text-sm">Email</h4>
                             <a href="mailto:info@ukbcci.org.uk" className="text-slate-500 text-sm hover:text-primary">info@ukbcci.org.uk</a>
                          </div>
                       </div>

                       <div className="flex items-start gap-4">
                          <div className="w-10 h-10 rounded-full bg-green-50 dark:bg-slate-700 flex items-center justify-center text-primary flex-shrink-0">
                             <Phone size={20} />
                          </div>
                          <div>
                             <h4 className="font-bold text-slate-900 dark:text-white text-sm">Phone</h4>
                             <a href="tel:07734394192" className="text-slate-500 text-sm hover:text-primary">07734 394192</a>
                          </div>
                       </div>

                       <div className="flex items-start gap-4">
                          <div className="w-10 h-10 rounded-full bg-green-50 dark:bg-slate-700 flex items-center justify-center text-primary flex-shrink-0">
                             <Clock size={20} />
                          </div>
                          <div>
                             <h4 className="font-bold text-slate-900 dark:text-white text-sm">Office Hours</h4>
                             <p className="text-slate-500 text-sm">Monday - Friday: 9:00 AM - 5:00 PM</p>
                          </div>
                       </div>
                    </div>
                 </div>

                 {/* Quick Links */}
                 <div className="bg-primary rounded-xl shadow-lg p-8 text-white">
                    <h3 className="text-xl font-bold mb-6">Quick Links</h3>
                    <ul className="space-y-4">
                       <li>
                          <Link href="/#membership" className="flex items-center gap-2 hover:translate-x-1 transition font-medium text-sm">
                             <ArrowRight size={16} /> Become a Member
                          </Link>
                       </li>
                       <li>
                          <Link href="/events" className="flex items-center gap-2 hover:translate-x-1 transition font-medium text-sm">
                             <ArrowRight size={16} /> Upcoming Events
                          </Link>
                       </li>
                       <li>
                          <Link href="/about" className="flex items-center gap-2 hover:translate-x-1 transition font-medium text-sm">
                             <ArrowRight size={16} /> Our Services
                          </Link>
                       </li>
                    </ul>
                 </div>

              </div>
           </div>
        </div>

        <Newsletter />

      </main>
      <Footer />
    </div>
  );
}