import { NextResponse } from 'next/server';
import dbConnect from '@/lib/db';
import User from '@/models/User';
import { hashPassword } from '@/lib/auth';

export async function GET() {
  await dbConnect();

  const email = 'admin@ukbcci.org.uk';
  const existingUser = await (User as any).findOne({ email });

  if (existingUser) {
    // If user exists, reset password to 'admin' to avoid confusion
    const hashedPassword = await hashPassword('admin');
    existingUser.password = hashedPassword;
    await existingUser.save();
    return NextResponse.json({ message: 'Admin exists. Password reset to "admin"' });
  }

  const hashedPassword = await hashPassword('admin');
  
  await (User as any).create({
    name: 'Super Admin',
    email,
    password: hashedPassword,
    role: 'admin'
  });

  return NextResponse.json({ message: 'Admin seeded successfully. Login with admin@ukbcci.org.uk / admin' });
}