import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import {
  Building2,
  Target,
  Eye,
  CheckCircle2,
  Award,
  Users,
  Globe,
  ShieldCheck,
  History,
  ArrowRight,
  Zap,
  HeartHandshake,
  Network,
  Briefcase,
  Factory,
  Truck,
  Leaf
} from 'lucide-react';
import Link from 'next/link';

const objectives = [
  'Promote bilateral trade and investment between the UK and Bangladesh',
  'Provide trusted networking opportunities for business leaders',
  'Facilitate trade missions and business delegations',
  'Offer business advisory services and market intelligence',
  'Advocate for favourable business policies and regulations',
  'Support skill development and professional growth of members',
  'Foster cultural exchange and cross-border collaboration',
  'Connect businesses with government bodies and key stakeholders'
];

const sectors = [
  { title: 'Manufacturing', icon: Factory },
  { title: 'Agri & Food', icon: Leaf },
  { title: 'Logistics', icon: Truck },
  { title: 'Professional Services', icon: Briefcase },
  { title: 'Finance & Investment', icon: Award },
  { title: 'Technology', icon: Zap }
];

export default function AboutPage() {
  return (
    <div className="min-h-screen flex flex-col bg-slate-50">
      <Navbar />
      <main className="flex-grow">
        {/* Hero */}
        <section className="relative h-[520px] flex items-center overflow-hidden bg-slate-900 text-white">
          <div className="absolute inset-0 z-0">
            <img
              src="https://images.unsplash.com/photo-1556761175-5973dc0f32e7?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80"
              alt="UKBCCI Team"
              className="w-full h-full object-cover opacity-30"
            />
            <div className="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/70 to-transparent"></div>
          </div>
          <div className="relative z-10 max-w-6xl mx-auto px-4">
            <div className="inline-flex items-center gap-2 border border-white/30 bg-white/10 backdrop-blur-md px-4 py-1.5 rounded-full text-xs font-semibold uppercase tracking-widest mb-6">
              Established 2014
            </div>
            <h1 className="text-5xl md:text-7xl font-bold font-display mb-6">
              About <span className="text-primary">UKBCCI</span>
            </h1>
            <p className="text-lg md:text-xl text-slate-300 leading-relaxed max-w-3xl">
              UK Bangladesh Catalysts of Commerce & Industry is a premier business chamber dedicated to strengthening trade, investment, and cultural ties between the United Kingdom and Bangladesh.
            </p>
            <div className="mt-8 flex flex-wrap gap-4">
              <Link href="/#membership" className="bg-primary hover:bg-primary-dark text-white px-7 py-3.5 rounded-full font-bold transition flex items-center gap-2">
                Become a Member <ArrowRight size={18} />
              </Link>
              <Link href="/contact" className="bg-white/10 border border-white/30 hover:bg-white/20 text-white px-7 py-3.5 rounded-full font-bold transition">
                Contact Us
              </Link>
            </div>
          </div>
        </section>

        {/* Who We Are */}
        <section className="py-24 bg-[linear-gradient(180deg,#ffffff_0%,#f3f7ff_100%)]">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid lg:grid-cols-2 gap-12 items-center">
              <div>
                <div className="flex items-center gap-2 mb-4">
                  <div className="w-10 h-0.5 bg-primary"></div>
                  <span className="text-sm font-bold uppercase tracking-widest text-primary">Who We Are</span>
                  <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
                </div>
                <h2 className="text-3xl md:text-4xl font-bold text-slate-900 font-display mb-6">
                  Building Bridges Between <span className="text-primary">UK & Bangladesh</span>
                </h2>
                <div className="text-slate-600 space-y-6 text-lg leading-relaxed">
                  <p>
                    UKBCCI is a trusted platform connecting entrepreneurs, business leaders, and organisations to create opportunities, foster growth, and enable cross-border collaboration.
                  </p>
                  <p>
                    With regional chapters across the UK and strong connections in Bangladesh, we provide access to trade missions, expert advisory, and high-impact networking.
                  </p>
                  <p>
                    Our mission is practical: unlock growth for members by turning relationships into measurable business outcomes.
                  </p>
                </div>
              </div>
              <div className="grid sm:grid-cols-2 gap-5">
                {[
                  { title: 'Cross-border Network', icon: Users, text: 'Direct access to decision makers and partners.' },
                  { title: 'Trade Facilitation', icon: HeartHandshake, text: 'Support to move from intent to execution.' },
                  { title: 'Policy Voice', icon: ShieldCheck, text: 'Advocacy for favourable business conditions.' },
                  { title: 'Member Services', icon: Building2, text: 'Guidance, intelligence, and resources.' }
                ].map((item) => (
                  <div key={item.title} className="bg-white rounded-2xl p-6 border border-slate-200 shadow-[0_18px_36px_-30px_rgba(15,23,42,0.45)]">
                    <div className="w-12 h-12 rounded-xl bg-emerald-100 text-primary flex items-center justify-center mb-4">
                      <item.icon size={22} />
                    </div>
                    <h3 className="text-slate-900 font-bold text-base mb-2">{item.title}</h3>
                    <p className="text-sm text-slate-600 leading-relaxed">{item.text}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </section>

        {/* Mission, Vision, Values */}
        <section className="py-24 bg-slate-950">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid md:grid-cols-3 gap-6">
              <div className="bg-slate-900/80 border border-slate-800 rounded-2xl p-8">
                <div className="w-12 h-12 rounded-xl bg-white/10 text-primary flex items-center justify-center mb-5">
                  <Target size={22} />
                </div>
                <h3 className="text-xl font-bold text-white mb-3">Our Mission</h3>
                <p className="text-slate-300 text-sm leading-relaxed">Strengthen UK-Bangladesh trade through partnerships, guidance, and a trusted network.</p>
              </div>
              <div className="bg-slate-900/80 border border-slate-800 rounded-2xl p-8">
                <div className="w-12 h-12 rounded-xl bg-white/10 text-blue-300 flex items-center justify-center mb-5">
                  <Eye size={22} />
                </div>
                <h3 className="text-xl font-bold text-white mb-3">Our Vision</h3>
                <p className="text-slate-300 text-sm leading-relaxed">Be the premier business chamber connecting UK and Bangladesh for sustainable growth.</p>
              </div>
              <div className="bg-slate-900/80 border border-slate-800 rounded-2xl p-8">
                <div className="w-12 h-12 rounded-xl bg-white/10 text-emerald-300 flex items-center justify-center mb-5">
                  <Award size={22} />
                </div>
                <h3 className="text-xl font-bold text-white mb-3">Our Values</h3>
                <p className="text-slate-300 text-sm leading-relaxed">Excellence, integrity, and collaboration in everything we do.</p>
              </div>
            </div>
          </div>
        </section>

        {/* Objectives */}
        <section className="py-24 bg-white">
          <div className="max-w-6xl mx-auto px-4">
            <div className="text-center mb-14">
              <h2 className="text-3xl md:text-4xl font-bold text-slate-900 font-display">Our <span className="text-primary">Objectives</span></h2>
              <div className="w-16 h-1 bg-primary mx-auto mt-6"></div>
            </div>
            <div className="grid md:grid-cols-2 gap-6">
              {objectives.map((item) => (
                <div key={item} className="flex items-start gap-4 bg-slate-50 p-5 rounded-xl border border-slate-200 hover:border-primary transition">
                  <div className="mt-1 text-primary">
                    <CheckCircle2 size={20} />
                  </div>
                  <p className="text-slate-700 font-medium text-base">{item}</p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Focus Sectors */}
        <section className="py-24 bg-[linear-gradient(180deg,#ffffff_0%,#f6f8fb_100%)] border-t border-slate-200">
          <div className="max-w-7xl mx-auto px-4">
            <div className="flex items-center gap-2 mb-6">
              <div className="w-10 h-0.5 bg-primary"></div>
              <span className="text-sm font-bold uppercase tracking-widest text-primary">Focus Sectors</span>
              <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 font-display mb-10">Where We Create Value</h2>
            <div className="grid md:grid-cols-3 gap-6">
              {sectors.map((sector) => (
                <div key={sector.title} className="bg-white p-6 rounded-2xl border border-slate-200 shadow-[0_18px_36px_-30px_rgba(15,23,42,0.35)]">
                  <div className="w-12 h-12 rounded-xl bg-emerald-100 text-primary flex items-center justify-center mb-4">
                    <sector.icon size={22} />
                  </div>
                  <h3 className="text-slate-900 font-bold">{sector.title}</h3>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Impact */}
        <section className="bg-[#0F172A] py-20 text-white border-y border-slate-800">
          <div className="max-w-7xl mx-auto px-4">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold font-display">Our <span className="text-primary">Impact</span></h2>
            </div>
            <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
              {[
                { value: '500+', label: 'Member Businesses' },
                { value: '£50M+', label: 'Facilitated Trade' },
                { value: '100+', label: 'Annual Events' },
                { value: '20+', label: 'Trade Missions' }
              ].map((stat) => (
                <div key={stat.label} className="p-4">
                  <div className="text-4xl md:text-5xl font-bold text-primary mb-2">{stat.value}</div>
                  <div className="text-xs uppercase tracking-widest text-slate-400 font-bold">{stat.label}</div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* CTA */}
        <section className="bg-white py-24">
          <div className="max-w-4xl mx-auto px-4 text-center">
            <h2 className="text-3xl md:text-5xl font-bold text-slate-900 font-display mb-6">Join UKBCCI Today</h2>
            <p className="text-lg text-slate-600 mb-10 max-w-2xl mx-auto">
              Become part of a thriving business community and unlock opportunities for growth, networking, and success in UK-Bangladesh trade.
            </p>
            <div className="flex flex-wrap justify-center gap-5">
              <Link href="/#membership" className="bg-primary hover:bg-primary-dark text-white px-8 py-3.5 rounded-full font-bold transition flex items-center gap-2 shadow-xl shadow-primary/25 text-base">
                Become a Member <ArrowRight size={18} />
              </Link>
              <Link href="/contact" className="bg-white border border-slate-300 text-slate-700 px-8 py-3.5 rounded-full font-bold transition hover:bg-slate-50 text-base">
                Contact Us
              </Link>
            </div>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
}
