# cPanel Deployment Instructions (Node.js App)

## 1. Preparation
1. **Build Locally (Optional but Recommended)**:
   Run `npm run build` locally to check for errors.
   *Note: You usually upload the source and build on cPanel, but for faster deployments, you can upload the `.next` folder.*
2. **Compress Files**:
   Select all files in your project root **EXCEPT** `node_modules`, `.git`, and `.next` (unless you built locally and want to upload the build, but usually incompatible OS issues arise).
   *Best practice:* Upload source, `npm install`, then `npm run build` on server.
   Zip the following:
   - `app/`
   - `components/`
   - `lib/`
   - `public/`
   - `scripts/` (if any needed)
   - `models/`
   - `package.json`
   - `package-lock.json`
   - `next.config.mjs`
   - `middleware.ts`
   - `server.js`
   - `tsconfig.json`
   - `instrumentation.ts` (if present)
   - `.env.example`

## 2. Setup Node.js App in cPanel
1. Log in to cPanel.
2. Go to **"Setup Node.js App"**.
3. Click **"Create Application"**.
4. **Node.js Version**: Select **20.x** (or 18.x).
5. **Application Mode**: **Production**.
6. **Application Root**: `ukbcci-cms` (the folder where files will live).
7. **Application URL**: Select your domain.
8. **Application Startup File**: `server.js` (Important! Do not leave default).
9. Click **Create**.

## 3. Upload Files
1. Allows cPanel to create the directory.
2. Go to **File Manager**.
3. Navigate to the folder (e.g., `ukbcci-cms`).
4. **Upload** your ZIP file.
5. **Extract** the ZIP file.

## 4. Install Dependencies
1. Go back to **"Setup Node.js App"** in cPanel.
2. Click **"Run NPM Install"**.
   *Troubleshooting:* If `sharp` fails to install, you might need to run `npm install --platform=linux --arch=x64 sharp` via SSH or relying on the build step. Usually, cPanel handles it if standard `npm install` works.

## 5. Configure Environment Variables
1. Creating a `.env` file in File Manager is Easiest.
   Create `.env` in the root `ukbcci-cms` folder.
   Add your content:
   ```env
   MONGODB_URI=your_mongodb_connection_string
   JWT_SECRET=your_secure_random_secret
   NEXT_PUBLIC_APP_URL=https://yourdomain.com
   NODE_ENV=production
   ```
   > [!WARNING]
   > **DO NOT** set the `PORT` variable. cPanel sets this automatically (usually to a named pipe). Implementation of `PORT` with a domain name will crash the app.

2. *Alternative:* Use the "Environment Variables" section in Node.js App Setup UI, but `.env` file often works more reliably with `dotenv`.

## 6. Build the Application
**Requirement:** Ensure you have completed **Step 4 (Install Dependencies)** successfully before proceeding.

1. **via SSH (Recommended)**:
   - `cd ukbcci-cms`
   - `source /home/username/nodevenv/ukbcci-cms/20/bin/activate` (Path varies, see cPanel "Enter to the virtual environment" command).
   - `npm run build`
2. **via NPM Script UI**:
   - In "Run NPM Script", select `build` and run.
   - *Warning:* cPanel UI often times out or runs out of memory. SSH or creating a cron job to run build is safer.
   - **IMPORTANT:** Once built, **DO NOT** click "Run" for `start` or `dev`. Proceed to the next step.

## 7. Restart
1. Scroll to the top of the page.
2. Click **"Restart Application"**.
   *(This automatically runs the `server.js` file we configured earlier).*
3. Visit your site.

## 8. Common Troubleshooting
- **503 Service Unavailable**:
  - Check `stderr.log` in the application folder.
  - Ensure `server.js` is set as startup file.
  - Ensure port is not hardcoded (Next.js uses the named pipe cPanel provides via `process.env.PORT`).
- **Sharp Error / Images not working**:
  - `rm -rf node_modules` and reinstall.
  - Ensure `public/uploads` folder exists and has write permissions (755).
- **"Internal Server Error" on Upload**:
  - Check permissions of `public/uploads`.

